module cpu
(
    // --- УПРАВЛЯЮЩИЕ
    input               clock,      // 25Мгц
    input               rst_n,      // =0 Сброс процессора
    input               ce,         // =1 Активация чипа
    output              m0,         // Первый такт
    // --- ПАМЯТЬ
    output      [19:0]  a,          // Адрес в общей памяти
    input       [ 7:0]  i,          // Данные из памяти
    output reg  [ 7:0]  o,          // Данные в память
    output reg          w,          // Запись в память,
    // --- РЕГИСТРЫ
    output reg  [15:0]  ax,
    output reg  [15:0]  bx,
    output reg  [15:0]  cx,
    output reg  [15:0]  dx,
    output reg  [15:0]  sp,
    output reg  [15:0]  bp,
    output reg  [15:0]  si,
    output reg  [15:0]  di,
    // --- СЕГМЕНТЫ
    output reg  [15:0]  es,
    output reg  [15:0]  cs,
    output reg  [15:0]  ss,
    output reg  [15:0]  ds,
    // --- УПРАВЛЯЮЩИЕ
    output reg  [15:0]  ip,
    output reg  [11:0]  flags,
    // --- ИНИЦИАЛИЗАЦИЯ
    input       [15:0]  _ax,
    input       [15:0]  _bx,
    input       [15:0]  _cx,
    input       [15:0]  _dx,
    input       [15:0]  _sp,
    input       [15:0]  _bp,
    input       [15:0]  _si,
    input       [15:0]  _di,
    input       [15:0]  _es,
    input       [15:0]  _cs,
    input       [15:0]  _ss,
    input       [15:0]  _ds,
    input       [15:0]  _ip,
    input       [11:0]  _flags
);

always @(posedge clock)
// Сброс процессора
if (rst_n == 0) begin

    // Копирование первоначальных значений при сбросе
    ax <= _ax; bx <= _bx; cx <= _cx; dx <= _dx;
    sp <= _sp; bp <= _bp; si <= _si; di <= _di;
    es <= _es; cs <= _cs; ss <= _ss; ds <= _ds;
    ip <= _ip; flags <= _flags;

// Запуск выполнения команд процессора
end
else if (ce) begin

end

endmodule
