`timescale 10ns / 1ns
module tb;

// --------------------------------
reg clock_25 = 0, clock_100 = 1, rst_n = 0;
// --------------------------------
always #0.5 clock_100 = ~clock_100;
always #2.0 clock_25  = ~clock_25;
// --------------------------------
reg [7:0] mem[1048576];
// --------------------------------
initial begin #4.0 rst_n = 1; #100 $finish; end
initial begin $dumpfile("tb.vcd"); $dumpvars(0, tb); end
initial begin $readmemh("tb.hex", mem, 20'h00000); end
// --------------------------------
wire [19:0] A; // Адрес (Address)
reg  [ 7:0] I; // Данные из памяти (In)
wire [ 7:0] O; // Данные в память (Out)
wire        W; // Сигнал записи (Write)
// --------------------------------
always @(posedge clock_100) begin I <= mem[A]; if (W) mem[A] <= O; end

endmodule
