`timescale 10ns / 1ns
module tb;

// --------------------------------
reg clock_25 = 0, clock_100 = 1, rst_n = 0;
// --------------------------------
always #0.5 clock_100 = ~clock_100;
always #2.0 clock_25  = ~clock_25;
// --------------------------------
reg [7:0] mem[1048576];
// --------------------------------
initial begin #4.0 rst_n = 1; #50 $finish; end
initial begin $dumpfile("tb.vcd"); $dumpvars(0, tb); end
initial begin $readmemh("tb.hex", mem, 20'hFFFF0); end
// --------------------------------
wire [19:0] A; // Адрес (Address)
reg  [ 7:0] I; // Данные из памяти (In)
wire [ 7:0] O; // Данные в память (Out)
wire        W; // Сигнал записи (Write)
// --------------------------------
always @(posedge clock_100) begin I <= mem[A]; if (W) mem[A] <= O; end
// --------------------------------

cpu C1
(
    .clock  (clock_25),
    .rst_n  (rst_n),
    .ce     (1'b1),
    // Подключение к контроллеру памяти
    .a      (A),
    .i      (I),
    .o      (O),
    .w      (W),
    // Первичное значение регистров
    ._ax    (16'h0000),
    ._bx    (16'h0000),
    ._cx    (16'h0000),
    ._dx    (16'h0000),
    ._sp    (16'h0000),
    ._bp    (16'h0000),
    ._si    (16'h0000),
    ._di    (16'h0000),
    ._es    (16'hA000),
    ._cs    (16'hF000),
    ._ss    (16'h0000),
    ._ds    (16'h0000),
    ._ip    (16'hFFF0),
    ._flags (12'b0000_0000_0000)
);

endmodule
