#include <SDL2/SDL.h>
#include <stdio.h>
// --------------------
SDL_Surface*    _surface  = NULL;
SDL_Window*     _window   = NULL;
SDL_Renderer*   _renderer = NULL;
SDL_Texture*    _texture  = NULL;
SDL_Rect        _dstRect;
SDL_Event       _evt;
Uint32          _palette[256];
Uint32          _pticks   = 0,
                _frame    = 0;
Uint32*         _screen   = NULL;
Uint16          _width    = 320,
                _height   = 200,
                _scale    = 2;
// --------------------
void    screen(int mode);
int     quit();
int     loop(int);
void    pset(int x, int y, int cl);
void    line(int x1, int y1, int x2, int y2, int color);
void    cls(int cl);
// --------------------
// Задать dos-цвета
static const Uint32 _doscolor[256] =
{
    0x000000, 0x0000aa, 0x00aa00, 0x00aaaa, 0xaa0000, 0xaa00aa, 0xaa5500, 0xaaaaaa, // 0
    0x555555, 0x5555ff, 0x55ff55, 0x55ffff, 0xff5555, 0xff55ff, 0xffff55, 0xffffff, // 8
    0x000000, 0x141414, 0x202020, 0x2c2c2c, 0x383838, 0x454545, 0x515151, 0x616161, // 10
    0x717171, 0x828282, 0x929292, 0xa2a2a2, 0xb6b6b6, 0xcbcbcb, 0xe3e3e3, 0xffffff, // 18
    0x0000ff, 0x4100ff, 0x7d00ff, 0xbe00ff, 0xff00ff, 0xff00be, 0xff007d, 0xff0041, // 20
    0xff0000, 0xff4100, 0xff7d00, 0xffbe00, 0xffff00, 0xbeff00, 0x7dff00, 0x41ff00, // 28
    0x00ff00, 0x00ff41, 0x00ff7d, 0x00ffbe, 0x00ffff, 0x00beff, 0x007dff, 0x0041ff, // 30
    0x7d7dff, 0x9e7dff, 0xbe7dff, 0xdf7dff, 0xff7dff, 0xff7ddf, 0xff7dbe, 0xff7d9e, // 38
    0xff7d7d, 0xff9e7d, 0xffbe7d, 0xffdf7d, 0xffff7d, 0xdfff7d, 0xbeff7d, 0x9eff7d, // 40
    0x7dff7d, 0x7dff9e, 0x7dffbe, 0x7dffdf, 0x7dffff, 0x7ddfff, 0x7dbeff, 0x7d9eff, // 48
    0xb6b6ff, 0xc7b6ff, 0xdbb6ff, 0xebb6ff, 0xffb6ff, 0xffb6eb, 0xffb6db, 0xffb6c7, // 50
    0xffb6b6, 0xffc7b6, 0xffdbb6, 0xffebb6, 0xffffb6, 0xebffb6, 0xdbffb6, 0xc7ffb6, // 58
    0xb6ffb6, 0xb6ffc7, 0xb6ffdb, 0xb6ffeb, 0xb6ffff, 0xb6ebff, 0xb6dbff, 0xb6c7ff, // 60
    0x000071, 0x1c0071, 0x380071, 0x550071, 0x710071, 0x710055, 0x710038, 0x71001c, // 68
    0x710000, 0x711c00, 0x713800, 0x715500, 0x717100, 0x557100, 0x387100, 0x1c7100, // 70
    0x007100, 0x00711c, 0x007138, 0x007155, 0x007171, 0x005571, 0x003871, 0x001c71, // 78
    0x383871, 0x453871, 0x553871, 0x613871, 0x713871, 0x713861, 0x713855, 0x713845, // 80
    0x713838, 0x714538, 0x715538, 0x716138, 0x717138, 0x617138, 0x557138, 0x457138, // 88
    0x387138, 0x387145, 0x387155, 0x387161, 0x387171, 0x386171, 0x385571, 0x384571, // 90
    0x515171, 0x595171, 0x615171, 0x695171, 0x715171, 0x715169, 0x715161, 0x715159, // 98
    0x715151, 0x715951, 0x716151, 0x716951, 0x717151, 0x697151, 0x617151, 0x597151, // A0
    0x517151, 0x517159, 0x517161, 0x517169, 0x517171, 0x516971, 0x516171, 0x515971, // A8
    0x000041, 0x100041, 0x200041, 0x300041, 0x410041, 0x410030, 0x410020, 0x410010, // B0
    0x410000, 0x411000, 0x412000, 0x413000, 0x414100, 0x304100, 0x204100, 0x104100, // B8
    0x004100, 0x004110, 0x004120, 0x004130, 0x004141, 0x003041, 0x002041, 0x001041, // C0
    0x202041, 0x282041, 0x302041, 0x382041, 0x412041, 0x412038, 0x412030, 0x412028, // C8
    0x412020, 0x412820, 0x413020, 0x413820, 0x414120, 0x384120, 0x304120, 0x284120, // D0
    0x204120, 0x204128, 0x204130, 0x204138, 0x204141, 0x203841, 0x203041, 0x202841, // D8
    0x2c2c41, 0x302c41, 0x342c41, 0x3c2c41, 0x412c41, 0x412c3c, 0x412c34, 0x412c30, // E0
    0x412c2c, 0x41302c, 0x41342c, 0x413c2c, 0x41412c, 0x3c412c, 0x34412c, 0x30412c, // E8
    0x2c412c, 0x2c4130, 0x2c4134, 0x2c413c, 0x2c4141, 0x2c3c41, 0x2c3441, 0x2c3041, // F0
    0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000  // F8
};

static const unsigned char dos866[4096] = {
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x7E,0x81,0xA5,0xA5,0xA5,0x81,0x81,0xBD,0x99,0x81,0x7E,0x00,0x00,0x00,
    0x00,0x00,0x7E,0xFF,0xDB,0xDB,0xDB,0xFF,0xFF,0xC3,0xE7,0xFF,0x7E,0x00,0x00,0x00,
    0x00,0x00,0x6C,0xFE,0xFE,0xFE,0xFE,0xFE,0xFE,0x7C,0x38,0x10,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x10,0x38,0x7C,0xFE,0x7C,0x38,0x10,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x18,0x3C,0x3C,0xE7,0xE7,0xE7,0x18,0x18,0x3C,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x18,0x3C,0x7E,0xFF,0xFF,0x7E,0x18,0x18,0x3C,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x18,0x3C,0x3C,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xE7,0xC3,0xC3,0xE7,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
    0x00,0x00,0x00,0x00,0x00,0x3C,0x66,0x42,0x42,0x66,0x3C,0x00,0x00,0x00,0x00,0x00,
    0xFF,0xFF,0xFF,0xFF,0xC3,0x99,0xBD,0xBD,0x99,0xC3,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
    0x00,0x00,0x00,0x1E,0x0E,0x1A,0x32,0x78,0xCC,0xCC,0xCC,0x78,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x3C,0x66,0x66,0x66,0x3C,0x18,0x7E,0x18,0x18,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x3F,0x33,0x3F,0x30,0x30,0x30,0x70,0xF0,0xE0,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x7F,0x63,0x7F,0x63,0x63,0x63,0x67,0xE7,0xE6,0xC0,0x00,0x00,0x00,
    0x00,0x00,0x00,0x18,0x18,0xDB,0x3C,0xE7,0x3C,0xDB,0x18,0x18,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x80,0xC0,0xE0,0xF8,0xFE,0xF8,0xE0,0xC0,0x80,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x02,0x06,0x0E,0x3E,0xFE,0x3E,0x0E,0x06,0x02,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x18,0x3C,0x7E,0x18,0x18,0x18,0x18,0x18,0x18,0x7E,0x3C,0x18,0x00,
    0x00,0x00,0x00,0x66,0x66,0x66,0x66,0x66,0x66,0x00,0x66,0x66,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x7F,0xDB,0xDB,0xDB,0x7B,0x1B,0x1B,0x1B,0x1B,0x00,0x00,0x00,0x00,
    0x00,0x00,0x7C,0xC6,0x60,0x38,0x6C,0xC6,0xC6,0x6C,0x38,0x0C,0xC6,0x7C,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFE,0xFE,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x18,0x3C,0x7E,0x18,0x18,0x18,0x7E,0x3C,0x18,0x7E,0x00,0x00,0x00,
    0x00,0x00,0x00,0x18,0x3C,0x7E,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x00,
    0x00,0x00,0x00,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x7E,0x3C,0x18,0x00,
    0x00,0x00,0x00,0x00,0x00,0x18,0x0C,0xFE,0x0C,0x18,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x30,0x60,0xFE,0x60,0x30,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0xC0,0xC0,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x28,0x6C,0xFE,0x6C,0x28,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x10,0x38,0x38,0x7C,0x7C,0xFE,0xFE,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0xFE,0x7C,0x38,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x18,0x3C,0x3C,0x3C,0x3C,0x18,0x18,0x18,0x00,0x00,0x18,0x00,0x00,0x00,
    0x00,0x66,0x66,0x66,0x66,0x66,0x24,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x6C,0x6C,0x6C,0xFE,0x6C,0x6C,0x6C,0xFE,0x6C,0x6C,0x6C,0x00,0x00,0x00,
    0x18,0x18,0x18,0x7C,0xC6,0xC2,0xC0,0x7C,0x06,0x86,0xC6,0x7C,0x18,0x18,0x18,0x00,
    0x00,0x00,0x00,0x00,0x00,0xC2,0xC6,0x0C,0x18,0x30,0x66,0xC6,0x00,0x00,0x00,0x00,
    0x00,0x00,0x38,0x6C,0x6C,0x6C,0x38,0x76,0xDC,0xCC,0xCC,0xCC,0x76,0x00,0x00,0x00,
    0x00,0x30,0x30,0x30,0x30,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x0C,0x18,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x18,0x0C,0x00,0x00,0x00,
    0x00,0x00,0x30,0x18,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x18,0x30,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x66,0x66,0x3C,0xFF,0x3C,0x66,0x66,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x18,0x18,0x18,0x7E,0x18,0x18,0x18,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x18,0x18,0x30,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x00,0x00,0x00,
    0x00,0x00,0x00,0x02,0x06,0x0C,0x18,0x30,0x60,0xC0,0x80,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x7C,0xC6,0xC6,0xCE,0xDE,0xF6,0xF6,0xE6,0xC6,0xC6,0x7C,0x00,0x00,0x00,
    0x00,0x00,0x18,0x18,0x38,0x78,0x18,0x18,0x18,0x18,0x18,0x18,0x7E,0x00,0x00,0x00,
    0x00,0x00,0x7C,0xC6,0xC6,0x06,0x06,0x0C,0x18,0x30,0x60,0xC6,0xFE,0x00,0x00,0x00,
    0x00,0x00,0x7C,0xC6,0x06,0x06,0x06,0x3C,0x06,0x06,0x06,0xC6,0x7C,0x00,0x00,0x00,
    0x00,0x00,0x0C,0x1C,0x3C,0x6C,0xCC,0xCC,0xFE,0x0C,0x0C,0x0C,0x1E,0x00,0x00,0x00,
    0x00,0x00,0xFE,0xC0,0xC0,0xC0,0xFC,0x06,0x06,0x06,0x06,0xC6,0x7C,0x00,0x00,0x00,
    0x00,0x00,0x38,0x60,0xC0,0xC0,0xFC,0xC6,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,
    0x00,0x00,0xFE,0xC6,0xC6,0x06,0x06,0x0C,0x18,0x30,0x30,0x30,0x30,0x00,0x00,0x00,
    0x00,0x00,0x7C,0xC6,0xC6,0xC6,0xC6,0x7C,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,
    0x00,0x00,0x7C,0xC6,0xC6,0xC6,0xC6,0xC6,0x7E,0x06,0x06,0x0C,0x78,0x00,0x00,0x00,
    0x00,0x00,0x00,0x18,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x00,0x00,0x00,
    0x00,0x00,0x00,0x18,0x18,0x00,0x00,0x00,0x00,0x18,0x18,0x18,0x18,0x30,0x00,0x00,
    0x00,0x00,0x00,0x06,0x0C,0x18,0x30,0x60,0x30,0x18,0x0C,0x06,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x7E,0x00,0x00,0x7E,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x60,0x30,0x18,0x0C,0x06,0x0C,0x18,0x30,0x60,0x00,0x00,0x00,0x00,
    0x00,0x00,0x7C,0xC6,0xC6,0xC6,0x0C,0x18,0x18,0x18,0x00,0x18,0x18,0x00,0x00,0x00,
    0x00,0x00,0x7C,0xC6,0xC6,0xC6,0xDE,0xDE,0xDE,0xDC,0xC0,0xC0,0x7C,0x00,0x00,0x00,
    0x00,0x00,0x10,0x38,0x6C,0xC6,0xC6,0xC6,0xFE,0xC6,0xC6,0xC6,0xC6,0x00,0x00,0x00,
    0x00,0x00,0xFC,0x66,0x66,0x66,0x66,0x7C,0x66,0x66,0x66,0x66,0xFC,0x00,0x00,0x00,
    0x00,0x00,0x7C,0xC6,0xC6,0xC0,0xC0,0xC0,0xC0,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,
    0x00,0x00,0xFC,0x66,0x66,0x66,0x66,0x66,0x66,0x66,0x66,0x66,0xFC,0x00,0x00,0x00,
    0x00,0x00,0xFE,0x66,0x62,0x60,0x68,0x78,0x68,0x68,0x62,0x66,0xFE,0x00,0x00,0x00,
    0x00,0x00,0xFE,0x66,0x62,0x60,0x68,0x78,0x68,0x68,0x60,0x60,0xF0,0x00,0x00,0x00,
    0x00,0x00,0x7C,0xC6,0xC6,0xC0,0xC0,0xC0,0xDE,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,
    0x00,0x00,0xC6,0xC6,0xC6,0xC6,0xC6,0xFE,0xC6,0xC6,0xC6,0xC6,0xC6,0x00,0x00,0x00,
    0x00,0x00,0x3C,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x3C,0x00,0x00,0x00,
    0x00,0x00,0x1E,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0xCC,0xCC,0x78,0x00,0x00,0x00,
    0x00,0x00,0xE6,0x66,0x66,0x6C,0x6C,0x78,0x6C,0x6C,0x66,0x66,0xE6,0x00,0x00,0x00,
    0x00,0x00,0xF0,0x60,0x60,0x60,0x60,0x60,0x60,0x60,0x62,0x66,0xFE,0x00,0x00,0x00,
    0x00,0x00,0xC6,0xC6,0xEE,0xFE,0xFE,0xD6,0xC6,0xC6,0xC6,0xC6,0xC6,0x00,0x00,0x00,
    0x00,0x00,0xC6,0xC6,0xE6,0xF6,0xFE,0xDE,0xCE,0xC6,0xC6,0xC6,0xC6,0x00,0x00,0x00,
    0x00,0x00,0x7C,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,
    0x00,0x00,0xFC,0x66,0x66,0x66,0x66,0x66,0x7C,0x60,0x60,0x60,0xF0,0x00,0x00,0x00,
    0x00,0x00,0x7C,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xD6,0xDE,0x7C,0x0C,0x00,0x00,0x00,
    0x00,0x00,0xFC,0x66,0x66,0x66,0x66,0x7C,0x6C,0x66,0x66,0x66,0xE6,0x00,0x00,0x00,
    0x00,0x00,0x7C,0xC6,0xC6,0xC6,0x60,0x38,0x0C,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,
    0x00,0x00,0x7E,0x7E,0x5A,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x3C,0x00,0x00,0x00,
    0x00,0x00,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,
    0x00,0x00,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0x6C,0x38,0x10,0x00,0x00,0x00,
    0x00,0x00,0xC6,0xC6,0xC6,0xC6,0xC6,0xD6,0xD6,0xFE,0x7C,0x6C,0x6C,0x00,0x00,0x00,
    0x00,0x00,0xC6,0xC6,0xC6,0x6C,0x38,0x38,0x38,0x6C,0xC6,0xC6,0xC6,0x00,0x00,0x00,
    0x00,0x00,0x66,0x66,0x66,0x66,0x66,0x3C,0x18,0x18,0x18,0x18,0x3C,0x00,0x00,0x00,
    0x00,0x00,0xFE,0xC6,0xC6,0x8C,0x18,0x30,0x60,0xC2,0xC6,0xC6,0xFE,0x00,0x00,0x00,
    0x00,0x00,0x3C,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x3C,0x00,0x00,0x00,
    0x00,0x00,0x00,0x80,0xC0,0xE0,0x70,0x38,0x1C,0x0E,0x06,0x02,0x00,0x00,0x00,0x00,
    0x00,0x00,0x3C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x3C,0x00,0x00,0x00,
    0x10,0x10,0x38,0x6C,0xC6,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0x00,
    0x30,0x30,0x30,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x78,0xCC,0x0C,0x7C,0xCC,0xCC,0xCC,0x76,0x00,0x00,0x00,
    0x00,0x00,0xE0,0x60,0x60,0x60,0x78,0x6C,0x66,0x66,0x66,0x66,0x7C,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x7C,0xC6,0xC6,0xC0,0xC0,0xC6,0xC6,0x7C,0x00,0x00,0x00,
    0x00,0x00,0x1C,0x0C,0x0C,0x0C,0x3C,0x6C,0xCC,0xCC,0xCC,0xCC,0x76,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x7C,0xC6,0xC6,0xFE,0xC0,0xC6,0xC6,0x7C,0x00,0x00,0x00,
    0x00,0x00,0x38,0x6C,0x64,0x60,0xF0,0x60,0x60,0x60,0x60,0x60,0xF0,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x76,0xCC,0xCC,0xCC,0xCC,0xCC,0x7C,0x0C,0xCC,0x78,0x00,
    0x00,0x00,0xE0,0x60,0x60,0x6C,0x76,0x66,0x66,0x66,0x66,0x66,0xE6,0x00,0x00,0x00,
    0x00,0x00,0x18,0x18,0x00,0x38,0x18,0x18,0x18,0x18,0x18,0x18,0x3C,0x00,0x00,0x00,
    0x00,0x00,0x06,0x06,0x00,0x0E,0x06,0x06,0x06,0x06,0x06,0x06,0x66,0x66,0x3C,0x00,
    0x00,0x00,0xE0,0x60,0x60,0x66,0x66,0x6C,0x78,0x6C,0x66,0x66,0xE6,0x00,0x00,0x00,
    0x00,0x00,0x38,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x3C,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0xEC,0xFE,0xD6,0xD6,0xD6,0xC6,0xC6,0xC6,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0xDC,0x66,0x66,0x66,0x66,0x66,0x66,0x66,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x7C,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0xDC,0x66,0x66,0x66,0x66,0x66,0x66,0x7C,0x60,0xF0,0x00,
    0x00,0x00,0x00,0x00,0x00,0x76,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0x7C,0x0C,0x1E,0x00,
    0x00,0x00,0x00,0x00,0x00,0xDC,0x76,0x66,0x60,0x60,0x60,0x60,0xF0,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x7C,0xC6,0xC6,0x70,0x1C,0xC6,0xC6,0x7C,0x00,0x00,0x00,
    0x00,0x00,0x10,0x30,0x30,0xFC,0x30,0x30,0x30,0x30,0x30,0x36,0x1C,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0x76,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x66,0x66,0x66,0x66,0x66,0x66,0x3C,0x18,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0xC6,0xC6,0xC6,0xD6,0xD6,0xFE,0x6C,0x6C,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0xC6,0xC6,0x6C,0x38,0x38,0x6C,0xC6,0xC6,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0x7E,0x06,0x0C,0xF8,0x00,
    0x00,0x00,0x00,0x00,0x00,0xFE,0xC6,0xCC,0x18,0x30,0x66,0xC6,0xFE,0x00,0x00,0x00,
    0x00,0x0E,0x18,0x18,0x18,0x18,0x18,0x70,0x70,0x18,0x18,0x18,0x18,0x18,0x0E,0x00,
    0x00,0x00,0x18,0x18,0x18,0x18,0x18,0x00,0x18,0x18,0x18,0x18,0x18,0x00,0x00,0x00,
    0x00,0x70,0x18,0x18,0x18,0x18,0x18,0x0E,0x0E,0x18,0x18,0x18,0x18,0x18,0x70,0x00,
    0x00,0x00,0x76,0xDC,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x10,0x38,0x6C,0xC6,0xC6,0xC6,0xC6,0xFE,0x00,0x00,0x00,0x00,
    0x00,0x00,0x10,0x38,0x6C,0xC6,0xC6,0xC6,0xFE,0xC6,0xC6,0xC6,0xC6,0x00,0x00,0x00,
    0x00,0x00,0xFE,0x66,0x62,0x60,0x7C,0x66,0x66,0x66,0x66,0x66,0xFC,0x00,0x00,0x00,
    0x00,0x00,0xFC,0x66,0x66,0x66,0x7C,0x66,0x66,0x66,0x66,0x66,0xFC,0x00,0x00,0x00,
    0x00,0x00,0xFE,0x66,0x62,0x60,0x60,0x60,0x60,0x60,0x60,0x60,0xF0,0x00,0x00,0x00,
    0x00,0x00,0x3E,0x66,0x66,0x66,0x66,0x66,0x66,0x66,0x66,0x66,0xFF,0xC3,0xC3,0x00,
    0x00,0x00,0xFE,0x66,0x66,0x62,0x68,0x78,0x68,0x62,0x66,0x66,0xFE,0x00,0x00,0x00,
    0x00,0x00,0xD6,0xD6,0xD6,0x7C,0x38,0x7C,0xD6,0xD6,0xD6,0xD6,0xD6,0x00,0x00,0x00,
    0x00,0x00,0x7C,0xC6,0x06,0x06,0x06,0x3C,0x06,0x06,0x06,0xC6,0x7C,0x00,0x00,0x00,
    0x00,0x00,0xC6,0xC6,0xCE,0xDE,0xFE,0xF6,0xE6,0xC6,0xC6,0xC6,0xC6,0x00,0x00,0x00,
    0x38,0x38,0xC6,0xC6,0xCE,0xDE,0xFE,0xF6,0xE6,0xC6,0xC6,0xC6,0xC6,0x00,0x00,0x00,
    0x00,0x00,0xE6,0x66,0x6C,0x6C,0x78,0x6C,0x6C,0x66,0x66,0x66,0xE6,0x00,0x00,0x00,
    0x00,0x00,0x3E,0x66,0x66,0x66,0x66,0x66,0x66,0x66,0x66,0x66,0xE6,0x00,0x00,0x00,
    0x00,0x00,0xC6,0xEE,0xFE,0xFE,0xD6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0x00,0x00,0x00,
    0x00,0x00,0xC6,0xC6,0xC6,0xC6,0xFE,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0x00,0x00,0x00,
    0x00,0x00,0x7C,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,
    0x00,0x00,0xFE,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0x00,0x00,0x00,
    0x00,0x00,0xFC,0x66,0x66,0x66,0x66,0x66,0x7C,0x60,0x60,0x60,0xF0,0x00,0x00,0x00,
    0x00,0x00,0x7C,0xC6,0xC6,0xC0,0xC0,0xC0,0xC0,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,
    0x00,0x00,0x7E,0x7E,0x5A,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x3C,0x00,0x00,0x00,
    0x00,0x00,0xC6,0xC6,0xC6,0xC6,0xC6,0x7E,0x06,0x06,0x06,0xC6,0x7C,0x00,0x00,0x00,
    0x00,0x00,0x18,0x7E,0xDB,0xDB,0xDB,0xDB,0xDB,0xDB,0xDB,0x7E,0x18,0x00,0x00,0x00,
    0x00,0x00,0xC6,0xC6,0xC6,0x6C,0x38,0x38,0x38,0x6C,0xC6,0xC6,0xC6,0x00,0x00,0x00,
    0x00,0x00,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xFE,0x06,0x06,0x00,
    0x00,0x00,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0x7E,0x06,0x06,0x06,0x06,0x00,0x00,0x00,
    0x00,0x00,0xD6,0xD6,0xD6,0xD6,0xD6,0xD6,0xD6,0xD6,0xD6,0xD6,0xFE,0x00,0x00,0x00,
    0x00,0x00,0xD6,0xD6,0xD6,0xD6,0xD6,0xD6,0xD6,0xD6,0xD6,0xD6,0xFE,0x03,0x03,0x00,
    0x00,0x00,0xF8,0xF0,0xB0,0x30,0x3C,0x36,0x36,0x36,0x36,0x36,0x7C,0x00,0x00,0x00,
    0x00,0x00,0xC6,0xC6,0xC6,0xC6,0xF6,0xDE,0xDE,0xDE,0xDE,0xDE,0xF6,0x00,0x00,0x00,
    0x00,0x00,0xF0,0x60,0x60,0x60,0x7C,0x66,0x66,0x66,0x66,0x66,0xFC,0x00,0x00,0x00,
    0x00,0x00,0x78,0xCC,0x86,0x86,0x26,0x3E,0x26,0x86,0x86,0xCC,0x78,0x00,0x00,0x00,
    0x00,0x00,0x9C,0xB6,0xB6,0xB6,0xB6,0xF6,0xB6,0xB6,0xB6,0xB6,0x9C,0x00,0x00,0x00,
    0x00,0x00,0x7E,0xCC,0xCC,0xCC,0xCC,0x7C,0x6C,0xCC,0xCC,0xCE,0xCE,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x78,0xCC,0x0C,0x7C,0xCC,0xCC,0xCC,0x76,0x00,0x00,0x00,
    0x00,0x00,0x00,0x1C,0x30,0x60,0x7C,0x66,0x66,0x66,0x66,0x66,0x3C,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0xFC,0x66,0x66,0x7C,0x66,0x66,0x66,0xFC,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0xFE,0x62,0x60,0x60,0x60,0x60,0x60,0xF0,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x3E,0x66,0x66,0x66,0x66,0x66,0x66,0xFF,0xC3,0xC3,0x00,
    0x00,0x00,0x00,0x00,0x00,0x7C,0xC6,0xC6,0xFE,0xC0,0xC0,0xC6,0x7C,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0xD6,0xD6,0xD6,0x7C,0x7C,0xD6,0xD6,0xD6,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x3C,0x66,0x66,0x0C,0x06,0x66,0x66,0x3C,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0xC6,0xCE,0xDE,0xFE,0xF6,0xE6,0xC6,0xC6,0x00,0x00,0x00,
    0x00,0x00,0x38,0x38,0x00,0xC6,0xCE,0xDE,0xFE,0xF6,0xE6,0xC6,0xC6,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0xE6,0x66,0x6C,0x78,0x6C,0x66,0x66,0xE6,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x3E,0x66,0x66,0x66,0x66,0x66,0x66,0xE6,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0xC6,0xEE,0xFE,0xFE,0xD6,0xC6,0xC6,0xC6,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0xC6,0xC6,0xC6,0xFE,0xC6,0xC6,0xC6,0xC6,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x7C,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0xFE,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0x00,0x00,0x00,
    0x44,0x11,0x44,0x11,0x44,0x11,0x44,0x11,0x44,0x11,0x44,0x11,0x44,0x11,0x44,0x11,
    0xAA,0x55,0xAA,0x55,0xAA,0x55,0xAA,0x55,0xAA,0x55,0xAA,0x55,0xAA,0x55,0xAA,0x55,
    0x77,0xDD,0x77,0xDD,0x77,0xDD,0x77,0xDD,0x77,0xDD,0x77,0xDD,0x77,0xDD,0x77,0xDD,
    0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,
    0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0xF8,0x18,0x18,0x18,0x18,0x18,0x18,0x18,
    0x18,0x18,0x18,0x18,0x18,0x18,0xF8,0x18,0xF8,0x18,0x18,0x18,0x18,0x18,0x18,0x18,
    0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0xF6,0x36,0x36,0x36,0x36,0x36,0x36,0x36,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0x36,0x36,0x36,0x36,0x36,0x36,0x36,
    0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x18,0xF8,0x18,0x18,0x18,0x18,0x18,0x18,0x18,
    0x36,0x36,0x36,0x36,0x36,0x36,0xF6,0x06,0xF6,0x36,0x36,0x36,0x36,0x36,0x36,0x36,
    0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,
    0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0x06,0xF6,0x36,0x36,0x36,0x36,0x36,0x36,0x36,
    0x36,0x36,0x36,0x36,0x36,0x36,0xF6,0x06,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x18,0x18,0x18,0x18,0x18,0x18,0xF8,0x18,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x18,0x18,0x18,0x18,0x18,0x18,0x18,
    0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x18,0x18,0x18,0x18,0x18,0x18,0x18,
    0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x1F,0x18,0x18,0x18,0x18,0x18,0x18,0x18,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0xFF,0x18,0x18,0x18,0x18,0x18,0x18,0x18,
    0x18,0x18,0x18,0x18,0x18,0x18,0x1F,0x18,0x1F,0x18,0x18,0x18,0x18,0x18,0x18,0x18,
    0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x37,0x36,0x36,0x36,0x36,0x36,0x36,0x36,
    0x36,0x36,0x36,0x36,0x36,0x36,0x37,0x30,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0x30,0x37,0x36,0x36,0x36,0x36,0x36,0x36,0x36,
    0x36,0x36,0x36,0x36,0x36,0x36,0xF7,0x00,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0xF7,0x36,0x36,0x36,0x36,0x36,0x36,0x36,
    0x36,0x36,0x36,0x36,0x36,0x36,0x37,0x30,0x37,0x36,0x36,0x36,0x36,0x36,0x36,0x36,
    0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x36,0x36,0x36,0x36,0x36,0x36,0xF7,0x00,0xF7,0x36,0x36,0x36,0x36,0x36,0x36,0x36,
    0x18,0x18,0x18,0x18,0x18,0x18,0xFF,0x00,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0xFF,0x18,0x18,0x18,0x18,0x18,0x18,0x18,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x36,0x36,0x36,0x36,0x36,0x36,0x36,
    0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x18,0x18,0x18,0x18,0x18,0x18,0x1F,0x18,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0x18,0x1F,0x18,0x18,0x18,0x18,0x18,0x18,0x18,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0x36,0x36,0x36,0x36,0x36,0x36,0x36,
    0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0xFF,0x36,0x36,0x36,0x36,0x36,0x36,0x36,
    0x18,0x18,0x18,0x18,0x18,0x18,0xFF,0x18,0xFF,0x18,0x18,0x18,0x18,0x18,0x18,0x18,
    0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0x18,0x18,0x18,0x18,0x18,0x18,0x18,
    0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
    0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,
    0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,
    0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0xDC,0x66,0x66,0x66,0x66,0x66,0x7C,0x60,0x60,0xF0,0x00,
    0x00,0x00,0x00,0x00,0x00,0x7C,0xC6,0xC6,0xC0,0xC0,0xC6,0xC6,0x7C,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x7E,0x5A,0x18,0x18,0x18,0x18,0x18,0x3C,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0x7E,0x06,0x0C,0xF8,0x00,
    0x00,0x00,0x00,0x00,0x00,0x18,0x7E,0xDB,0xDB,0xDB,0xDB,0xDB,0x7E,0x18,0x18,0x00,
    0x00,0x00,0x00,0x00,0x00,0xC6,0xC6,0x6C,0x38,0x38,0x6C,0xC6,0xC6,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xFE,0x06,0x06,0x00,
    0x00,0x00,0x00,0x00,0x00,0xC6,0xC6,0xC6,0xC6,0x7E,0x06,0x06,0x06,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0xD6,0xD6,0xD6,0xD6,0xD6,0xD6,0xD6,0xFE,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0xD6,0xD6,0xD6,0xD6,0xD6,0xD6,0xD6,0xFE,0x03,0x03,0x00,
    0x00,0x00,0x00,0x00,0x00,0xF8,0xB0,0x3C,0x36,0x36,0x36,0x36,0x7C,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0xC6,0xC6,0xF6,0xDE,0xDE,0xDE,0xDE,0xF6,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0xF0,0x60,0x60,0x7C,0x66,0x66,0x66,0xFC,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x3C,0x66,0x06,0x1E,0x06,0x66,0x66,0x3C,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x9C,0xB6,0xB6,0xF6,0xB6,0xB6,0xB6,0x9C,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x7E,0xCC,0xCC,0xCC,0x7C,0x6C,0xCC,0xCE,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0xFE,0x00,0x00,0xFE,0x00,0x00,0xFE,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x18,0x18,0x7E,0x18,0x18,0x00,0x00,0xFF,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x30,0x18,0x0C,0x06,0x0C,0x18,0x30,0x00,0x7E,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x0C,0x18,0x30,0x60,0x30,0x18,0x0C,0x00,0x7E,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x0E,0x1B,0x1B,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,
    0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0xD8,0xD8,0x70,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x18,0x18,0x00,0x7E,0x00,0x18,0x18,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x76,0xDC,0x00,0x76,0xDC,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x38,0x6C,0x6C,0x6C,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x0F,0x0C,0x0C,0x0C,0x0C,0x0C,0xEC,0x6C,0x3C,0x1C,0x0C,0x00,0x00,0x00,0x00,
    0x00,0x00,0xD8,0x6C,0x6C,0x6C,0x6C,0x6C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x70,0xD8,0x30,0x60,0xC8,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x3C,0x3C,0x3C,0x3C,0x3C,0x3C,0x3C,0x3C,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
};

// Инициализация окна SDL2
void screen(int mode = 13)
{
    if (SDL_Init(SDL_INIT_VIDEO | SDL_INIT_AUDIO)) {
        exit(1);
    }

    // Выбор видео-режима по цифровому коду
    switch (mode)
    {
        case 3:  _width = 640; _height = 400; _scale = 2; break;
        case 12: _width = 640; _height = 480; _scale = 2; break;
        case 13: _width = 320; _height = 200; _scale = 4; break;
        default: exit(0);
    }

    _dstRect.x = 0;
    _dstRect.y = 0;
    _dstRect.w = _scale * _width;
    _dstRect.h = _scale * _height;

    SDL_ClearError();

    // Создать окно с заданной структурой
    _window   = SDL_CreateWindow("C:Surface",
        SDL_WINDOWPOS_CENTERED,
        SDL_WINDOWPOS_CENTERED,
        _dstRect.w,
        _dstRect.h,
        SDL_WINDOW_SHOWN
    );

    _renderer = SDL_CreateRenderer(_window, -1, SDL_RENDERER_PRESENTVSYNC);
    _screen   = (Uint32*) malloc(_width * _height * sizeof(Uint32));
    _texture  = SDL_CreateTexture(_renderer,
        SDL_PIXELFORMAT_BGRA32,
        SDL_TEXTUREACCESS_STREAMING,
        _width,
        _height
    );

    SDL_SetTextureBlendMode(_texture, SDL_BLENDMODE_NONE);

    // Данную палитру можно потом менять
    for (int i = 0; i < 256; i++) _palette[i] = _doscolor[i];

    cls(0);
}

// Закрыть программу
int quit()
{
    if (_window) {

        free(_screen);
        SDL_DestroyTexture(_texture);
        SDL_DestroyRenderer(_renderer);
        SDL_DestroyWindow(_window);
        SDL_Quit();
    }

    return 0;
}

// Прием событий
int loop(int delay = 16)
{
    // Ждать окончания кадра
    for (;;) {

        while (SDL_PollEvent(& _evt)) {

            // Событие выхода
            switch (_evt.type) {

                case SDL_QUIT:
                    return 0;

                 case SDL_KEYDOWN:
                    // kbd_scancode(evt.key.keysym.scancode, 0);
                    break;

                case SDL_KEYUP:
                    // kbd_scancode(evt.key.keysym.scancode, 1);
                    break;
            }
        }

        // Обновление N раз в секунду
        Uint32 nticks = SDL_GetTicks();
        Uint32 diff   = nticks - _pticks;

        // Кадр был обработан успешно
        if (diff >= delay) {

            SDL_UpdateTexture       (_texture, NULL, _screen, _width * sizeof(Uint32));
            SDL_SetRenderDrawColor  (_renderer, 0, 0, 0, 0);
            SDL_RenderClear         (_renderer);
            SDL_RenderCopy          (_renderer, _texture, NULL, & _dstRect);
            SDL_RenderPresent       (_renderer);

            _pticks = nticks;
            _frame++;

            return 1;
        }

        SDL_Delay(1);
    }
}

// Установка точки
void pset(int x, int y, int cl)
{
    if (x < 0 || y < 0 || x >= _width || y >= _height) {
        return;
    }

    _screen[_width * y + x] = cl < 0 ? -cl : _palette[cl & 255];
}

// Очистить экран
void cls(int cl = 0)
{
    cl = cl < 0 ? -cl : _palette[cl & 255];
    for (int i = 0; i < _width * _height; i++) {
        _screen[i] = cl;
    }
}

// Рисовать линию
void line(int x1, int y1, int x2, int y2, int color)
{
    // Инициализация смещений
    int signx  = x1 < x2 ? 1 : -1;
    int signy  = y1 < y2 ? 1 : -1;
    int deltax = x2 > x1 ? x2 - x1 : x1 - x2;
    int deltay = y2 > y1 ? y2 - y1 : y1 - y2;
    int error  = deltax - deltay;
    int error2;

    // Если линия - это точка
    pset(x2, y2, color);

    // Перебирать до конца
    while ((x1 != x2) || (y1 != y2)) {

        pset(x1, y1, color);
        error2 = 2 * error;

        if (error2 > -deltay) { error -= deltay; x1 += signx; }   // Коррекция по X
        if (error2 <  deltax) { error += deltax; y1 += signy; }   // Коррекция по Y
    }
}

// Закрашенный блок
void linebf(int x1, int y1, int x2, int y2, int cl)
{
    for (int y = y1; y <= y2; y++)
    for (int x = x1; x <= x2; x++)
        pset(x, y, cl);
}

// Сохранить один фрейм в файл
void save(const char* s = NULL)
{
    FILE* fp = s ? fopen(s, "wb") : stdout;
    if (fp) {

        fprintf(fp, "P6\n#QBLib!\n%d %d\n255\n", _width, _height);
        for (int i = 0; i < _width*_height; i++) {

            Uint32 a = _screen[i];
            a = (a >> 16) | ((a & 255) << 16) | (a & 0xFF00);
            fwrite(&a, 3, 1, fp);
        }

        if (s) fclose(fp);
    }
}

// Загрузка палитры
void palette(const unsigned char arr[][4], int num)
{
    for (int i = 0; i < num - 1; i++) {

        int s = arr[i][0],   r1 = arr[i][1],   g1 = arr[i][2],   b1 = arr[i][3];
        int e = arr[i+1][0], r2 = arr[i+1][1], g2 = arr[i+1][2], b2 = arr[i+1][3];

        for (int j = s; j <= e; j++) {

            int r = (j - s) * (r2 - r1) / (e - s) + r1;
            int g = (j - s) * (g2 - g1) / (e - s) + g1;
            int b = (j - s) * (b2 - b1) / (e - s) + b1;

            _palette[j] = (r&255)*65536 + (g&255)*256 + (b&255);
        }
    }
}

// Пропечатка символов
void print(const char* s, int x = 0, int y = 0, int cl = 15)
{
    int n = 0;
    unsigned char ch, mask;

    while ((ch = s[n++])) {

        for (int i = 0; i < 16; i++) {

            mask = dos866[16*ch+i];
            for (int j = 0; j < 8; j++) {

                if (mask & 0x80) pset(x + j, y + i, cl);
                mask <<= 1;
            }
        }

        x += 8;
    }
}
